/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed*0.3
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.
//
// With VGHD if no other texture has been selected by the .scn file iChannel0
// will pick up the performer or the performers name sprite.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

#define PI  3.14159265359
#define PI2 ( PI * 2.0 )

mat2 rotate(float a)
{
   return mat2(cos(a), sin(a), -sin(a), cos(a));   
}

float sdTorus(in vec3 p, in vec2 t)
{
  vec2 q = vec2(length(p.xz) - t.x, p.y);
  return length(q) - t.y;
}

float deTorusKnot(in vec3 p)
{
    const float n = 5.0;
    float f = 10.0;
    float r = 0.4;
    f /= n;    
    float a = atan(p.z, p.x);
    float de = 100.0;
    for(float i = 0.0; i < n; i++)
    {
      vec3 q = p;
      q.xz += normalize(p.xz) * r * sin(a * f);
      q.y += r * cos(a * f);
      de = min(de, sdTorus(q, vec2(1.0, 0.1)));
      a += PI2 / n / f;
    }
    return 0.75 * de;    
}

float map(in vec3 p)
{
    return deTorusKnot(p);
}

vec3 calcNormal(in vec3 p)
{
   const vec2 e = vec2(0.0001, 0.0);
   return normalize(vec3(
      map(p + e.xyy) - map(p - e.xyy),
      map(p + e.yxy) - map(p - e.yxy),
      map(p + e.yyx) - map(p - e.yyx)));
}

float march(in vec3 ro, in vec3 rd)
{
   const float maxd = 50.0;
   const float precis = 0.001;
   float h = precis * 2.0;
   float t = 0.0;
   float res = -1.0;
   for(int i = 0; i < 64; i++)
    {
       if(h < precis || t > maxd) break;
       h = map(ro + rd * t);
       t += h;
    }
    if(t < maxd) res = t;
    return res;
}

vec3 transform(in vec3 p)
{
    p.yz *= rotate(0.8 * sin(iGlobalTime * 0.2));
    p.zx *= rotate(iGlobalTime * 0.8);
    p.zx *= rotate(-0.3 * smoothstep(0.0, 2.0, abs(mod(iGlobalTime, 10.0) - 5.0)));
    return p;
}

void main(void)
{
   vec2 p = (2.0 * gl_FragCoord.xy - iResolution.xy) / iResolution.y;
   vec3 col = vec3(0.0);
   vec3 rd = normalize(vec3(p, -1.8));
   vec3 ro = vec3(0.0, 0.0, 1.6 + 0.3*sin(iGlobalTime*0.4));
   vec3 li = normalize(vec3(0.5, 0.8, 3.0));
   ro = transform(ro);
   rd = transform(rd);
   li = transform(li);
   float t = march(ro, rd);
   if(t > -0.001)
    {
      vec3 pos = ro + t * rd;
      vec3 n = calcNormal(pos);
      float dif = clamp((dot(n, li) + 0.5) * 0.7, 0.3, 1.0);
      float dep = exp(-pos.z * pos.z);
      col = texture2D(iChannel0, pos.xz).xyz * dif * dep;
      col = pow(col, vec3(0.8));
   }
   gl_FragColor = vec4(col, length(col)*100.0);
}
